package gov.va.med.mhv.vitals.converter;

import gov.va.med.mhv.vitals.dto.BloodPressureReadingDTO;
import gov.va.med.mhv.vitals.model.BloodPressureReading;

import java.util.ArrayList;
import java.util.List;

public class BloodPressureConverter {
	
	public static BloodPressureReadingDTO  convertBPReadingDomain( BloodPressureReading bpReading ){
		BloodPressureReadingDTO dto = new BloodPressureReadingDTO();
		dto.setBloodPressureId(bpReading.getId());
		dto.setComments(bpReading.getComments());
		dto.setDiastolic(bpReading.getDiastolic());
		dto.setReading(bpReading.getReading());
		dto.setSystolic(bpReading.getSystolic());
		dto.setUserprofileId(bpReading.getUserprofileId());
		return dto;
	}
	
	
	public static BloodPressureReading convertBPReadingDTO(BloodPressureReadingDTO bpReadingDTO){
		BloodPressureReading bpReading = new BloodPressureReading();
		bpReading.setComments(bpReadingDTO.getComments());
		bpReading.setDiastolic(bpReadingDTO.getDiastolic());
		bpReading.setId(bpReadingDTO.getBloodPressureId());
		bpReading.setOplock(0);
		bpReading.setReading(bpReadingDTO.getReading());
		bpReading.setSystolic(bpReadingDTO.getSystolic());
		bpReading.setUserprofileId(bpReadingDTO.getUserprofileId());
		return bpReading;
	}
	
	
	public static List<BloodPressureReadingDTO>  convertBPReadings( List<BloodPressureReading> bpReadings ){
		List<BloodPressureReadingDTO> bpReadingDTOS = new ArrayList<BloodPressureReadingDTO>();
		for(BloodPressureReading bpReading : bpReadings){
			BloodPressureReadingDTO dto = convertBPReadingDomain(bpReading);
			bpReadingDTOS.add(dto);
		}
		return bpReadingDTOS;
	}

}
